% By Mikolaj Roguski, April 2025
% This code is a part of the data package and can 
% be used for extracting raw data from .fig plots. 

% How to use:
% #1 Choose .fig file to extract
% #2 Choose 
% #3 Data is stored as xdata and ydata variables. 
% #4 (optionally) Check the extracted data by simple plotting

% Filenames to choose from:
%   'Figure 2/Figure2_matlab_data.fig'
%   'Figure 4/Figure4_matlab_data_combined.fig' -- contains file numbers
%   'Figure 5/Figure5_matlab_data_A.fig'
%   'Figure 5/Figure5_matlab_data_B.fig'
%   'Figure 6/Figure6_matlab_data.fig'
%   'Figure 7/Figure7_matlab_data_stateA.fig'
%   'Figure 7/Figure7_matlab_data_stateB.fig'


%% Extract data from .fig 
close all ;
clear ;

% File to extract data from (#1)
filename = 'Figure 7/Figure7_matlab_data_stateB.fig' ;

% Open as main figure 
fig_handle = openfig(filename);

% List contents of the .fig file 
axes_handle = findobj(fig_handle, 'Type', 'axes') ;  % handle to the plotted line object
objs = axes_handle.Children % prints the objects: lines, errorbars etc.

% Extract data 
object_no = 1 ; % choose line to extract (#2)
[xdata, ydata] = FigureDataExtract_fun(fig_handle, object_no) ;

% Close main figure 
close(fig_handle)



%% Simple plotting to check data extraction (#4)
if true
    % Define which objects to plot
    object_no_list = 1:2 ;
    
    % Define fig filename and open main figure 
    fig_handle = openfig(filename);
    
    % Extract data from the data axes
    figure ;
    hold on;
    for object_no = object_no_list
        [xdata, ydata] = FigureDataExtract_fun(fig_handle, object_no) ;
        plot(xdata, ydata, 'o-', 'LineWidth', 2, 'MarkerSize', 10) ;
    end 
    
    
    set(0, 'DefaultFigurePosition', [100, 100, 800, 600]);
    box on ;
    set(gca, 'LineWidth', 1.5)
    set(gca, 'FontSize', 18);
    set(gca, 'FontName','Avenir Next');
    hold off;

    % Close main figure 
    close(fig_handle)
end 

 


function [xdata, ydata] = FigureDataExtract_fun(fig_handle, object_no)
    % Extract data from current plot into xdata and ydata lists 
    axes_handle = findobj(fig_handle, 'Type', 'axes') ;  % handle to the plotted line object
    objs = axes_handle.Children ;

    % Extract x and y data
    xdata = objs(object_no).XData ; 
    ydata = objs(object_no).YData ;
end

